
import gurobipy as gp

# Create a new model
model = gp.Model("Scooter_Optimization")

# Define variables
x1 = model.addVar(name="foldable_scooters", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="electric_scooters", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(150*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(1.5*x1 + 3*x2 <= 4000, name="design_team_hours")
model.addConstr(4*x1 + 6*x2 <= 5000, name="engineering_team_hours")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Production levels: {x1.varValue} foldable scooters, {x2.varValue} electric scooters")
else:
    print("No optimal solution found.")
