
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("animal_feed")

# Create variables
oats = m.addVar(nonnegative=True, name="oats")  # Kilograms of oats
sunflower = m.addVar(nonnegative=True, name="sunflower")  # Kilograms of sunflower seeds

# Set objective function: Minimize the cost
m.setObjective(50 * oats + 70 * sunflower, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * oats + 10 * sunflower >= 250, "protein_req")  # Protein requirement
m.addConstr(16 * oats + 22 * sunflower >= 400, "fat_req")  # Fat requirement

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Kilograms of oats: {oats.x:.2f}")
    print(f"Kilograms of sunflower seeds: {sunflower.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

