
from gurobipy import *

# Create a new model
m = Model("animal_feed")

# Add variables
x1 = m.addVar(lb=0, name="oats")
x2 = m.addVar(lb=0, name="sunflower_seeds")

# Set the objective function
m.setObjective(50*x1 + 70*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 10*x2 >= 250, "protein_constraint")
m.addConstr(16*x1 + 22*x2 >= 400, "fat_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oats: {x1.x} kg")
    print(f"Sunflower seeds: {x2.x} kg")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")
