
import gurobi

def solve_animal_feed_mixture():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="oats", lb=0)  # Amount of oats
    x2 = model.addVar(name="sunflower_seeds", lb=0)  # Amount of sunflower seeds

    # Objective function: Minimize the cost
    model.setObjective(50 * x1 + 70 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * x1 + 10 * x2 >= 250, name="protein_constraint")
    model.addConstr(16 * x1 + 22 * x2 >= 400, name="fat_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Amount of oats: {x1.varValue} kg")
        print(f"Amount of sunflower seeds: {x2.varValue} kg")
        print(f"Total cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_animal_feed_mixture()
