
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Cautious_Asset_Investment")

# Create variables
investment_mmf = m.addVar(name="investment_mmf") # Investment in money market fund
investment_fb = m.addVar(name="investment_fb")   # Investment in foreign bonds

# Set objective function
m.setObjective(0.02 * investment_mmf + 0.102 * investment_fb, GRB.MAXIMIZE)

# Add constraints
m.addConstr(investment_mmf + investment_fb <= 150000, "Total_Investment")
m.addConstr(investment_mmf >= 0.4 * 150000, "Min_MMF")
m.addConstr(investment_fb <= 0.4 * 150000, "Max_FB")
m.addConstr(investment_mmf >= 0, "Non_negativity_MMF")  # Ensure non-negative investment
m.addConstr(investment_fb >= 0, "Non_negativity_FB")    # Ensure non-negative investment


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in money market fund: ${investment_mmf.x:.2f}")
    print(f"Optimal investment in foreign bonds: ${investment_fb.x:.2f}")
    print(f"Maximum average return: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

