
from gurobipy import *

# Create a new model
m = Model("Cautious_Asset_Investment")

# Define variables
x1 = m.addVar(name="money_market_fund", lb=0)
x2 = m.addVar(name="foreign_bonds", lb=0)

# Set the objective function
m.setObjective(0.02*x1 + 0.102*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 150000, name="total_investment")
m.addConstr(x1 >= 0.4 * 150000, name="min_money_market_fund")
m.addConstr(x2 <= 0.4 * 150000, name="max_foreign_bonds")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Money Market Fund: ${x1.x:.2f}")
    print(f"Foreign Bonds: ${x2.x:.2f}")
    print(f"Maximum Average Return: {m.objVal:.4f}")
else:
    print("No optimal solution found")
