
import gurobipy as gp

# Create a new model
m = gp.Model("Cautious Asset Investment")

# Define variables
x1 = m.addVar(name="investment_in_money_market_fund", lb=0)
x2 = m.addVar(name="investment_in_foreign_bonds", lb=0)

# Objective function: maximize 0.02*x1 + 0.102*x2
m.setObjective(0.02*x1 + 0.102*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 == 150000, name="total_investment")
m.addConstr(0.6*x1 - 0.4*x2 >= 0, name="min_investment_in_money_market_fund")
m.addConstr(-0.4*x1 + 0.6*x2 <= 0, name="max_investment_in_foreign_bonds")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal investment in money market fund: ", x1.varValue)
    print("Optimal investment in foreign bonds: ", x2.varValue)
    print("Optimal return: ", 0.02*x1.varValue + 0.102*x2.varValue)
else:
    print("The model is infeasible")
