
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
chocolate = m.addVar(name="chocolate")
coffee = m.addVar(name="coffee")
peanut_butter = m.addVar(name="peanut_butter")
maple_syrup = m.addVar(name="maple_syrup")

# Set objective function
m.setObjective(0.05 * chocolate + 0.10 * coffee + 0.07 * peanut_butter + 0.06 * maple_syrup, GRB.MAXIMIZE)

# Add constraints
m.addConstr(chocolate + coffee + peanut_butter + maple_syrup <= 300000, "total_investment")
m.addConstr(chocolate <= maple_syrup, "chocolate_maple")
m.addConstr(coffee <= peanut_butter, "coffee_peanut")
m.addConstr(maple_syrup <= 0.20 * 300000, "maple_limit")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Invest in Chocolate Company: ${chocolate.x:.2f}")
    print(f"Invest in Coffee Company: ${coffee.x:.2f}")
    print(f"Invest in Peanut Butter Company: ${peanut_butter.x:.2f}")
    print(f"Invest in Maple Syrup Company: ${maple_syrup.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

