
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="chocolate", lb=0)
x2 = m.addVar(name="coffee", lb=0)
x3 = m.addVar(name="peanut_butter", lb=0)
x4 = m.addVar(name="maple_syrup", lb=0)

# Objective function
m.setObjective(0.05*x1 + 0.10*x2 + 0.07*x3 + 0.06*x4, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 + x3 + x4 <= 300000, name="total_investment")
m.addConstr(x1 <= x4, name="chocolate_maple_syrup")
m.addConstr(x2 <= x3, name="coffee_peanut_butter")
m.addConstr(x4 <= 60000, name="maple_syrup_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Chocolate: ${x1.varValue:.2f}")
    print(f"Coffee: ${x2.varValue:.2f}")
    print(f"Peanut Butter: ${x3.varValue:.2f}")
    print(f"Maple Syrup: ${x4.varValue:.2f}")
    print(f"Total Return: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
