
import gurobipy as gp

# Create a new model
m = gp.Model("laptop_production")

# Create variables
regular = m.addVar(vtype=gp.GRB.CONTINUOUS, name="regular")
touchscreen = m.addVar(vtype=gp.GRB.CONTINUOUS, name="touchscreen")


# Set objective function
m.setObjective(200 * regular + 300 * touchscreen, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * regular + 25 * touchscreen <= 3000, "manual_labor")
m.addConstr(10 * regular + 20 * touchscreen <= 2000, "calibration")
m.addConstr(regular >= 0, "regular_nonnegative")  # Ensure non-negative production
m.addConstr(touchscreen >= 0, "touchscreen_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of regular laptops to produce: {regular.x}")
    print(f"Number of touchscreen laptops to produce: {touchscreen.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

