
from gurobipy import *

# Create a new model
model = Model("Laptop_Production")

# Create variables
x1 = model.addVar(vtype=GRB.INTEGER, name="regular_laptops")
x2 = model.addVar(vtype=GRB.INTEGER, name="touchscreen_laptops")

# Set the objective function
model.setObjective(200*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 25*x2 <= 3000, "manual_labor")
model.addConstr(10*x1 + 20*x2 <= 2000, "calibration")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Laptops: {x1.x}")
    print(f"Touchscreen Laptops: {x2.x}")
    print(f"Maximum Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
