
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="regular_laptops")
    x2 = model.addVar(lb=0, name="touchscreen_laptops")

    # Define the objective function
    model.setObjective(200*x1 + 300*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(20*x1 + 25*x2 <= 3000, name="manual_labor_constraint")
    model.addConstr(10*x1 + 20*x2 <= 2000, name="calibration_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of regular laptops: {x1.varValue}")
        print(f"Number of touchscreen laptops: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
