
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_truck")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="burritos") # orders of burritos
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="tacitos") # orders of tacitos


# Set objective function
m.setObjective(17*x1 + 12*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 30, "min_burritos")
m.addConstr(x1 <= 100, "max_burritos")
m.addConstr(x2 >= 20, "min_tacitos")
m.addConstr(x2 <= 150, "max_tacitos")
m.addConstr(x1 + x2 <= 250, "total_orders")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal revenue: ${m.objVal}")
    print(f"Number of burritos to sell: {x1.x}")
    print(f"Number of tacitos to sell: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

