
from gurobipy import *

# Create a model
m = Model("FoodTruckRevenue")

# Define variables
x1 = m.addVar(name="burritos", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="tacitos", vtype=GRB.CONTINUOUS, lb=0)

# Set objective function
m.setObjective(17*x1 + 12*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 30, name="min_burritos")
m.addConstr(x1 <= 100, name="max_burritos")
m.addConstr(x2 >= 20, name="min_tacitos")
m.addConstr(x2 <= 150, name="max_tacitos")
m.addConstr(x1 + x2 <= 250, name="total_orders")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Burritos: {x1.x}")
    print(f"Tacitos: {x2.x}")
    print(f"Revenue: {17*x1.x + 12*x2.x}")
else:
    print("No optimal solution found")
