
import gurobipy as gp

# Create a new model
m = gp.Model("Burritos_and_Tacitos")

# Define variables
x1 = m.addVar(lb=30, ub=100, name="burritos")
x2 = m.addVar(lb=20, ub=150, name="tacitos")

# Objective function: maximize revenue
m.setObjective(17*x1 + 12*x2, gp.GRB.MAXIMIZE)

# Additional constraint: total orders cannot exceed 250
m.addConstr(x1 + x2 <= 250)

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
  print("Optimal solution found.")
  print(f"Burritos: {x1.varValue}")
  print(f"Tacitos: {x2.varValue}")
  print(f"Max Revenue: {17*x1.varValue + 12*x2.varValue}")
else:
  print("No optimal solution found.")
