
import gurobipy as gp

# Create a new model
m = gp.Model("taco_optimization")

# Create variables
fish_tacos = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="fish_tacos")
chicken_tacos = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chicken_tacos")


# Set objective function
m.setObjective(6 * fish_tacos + 4 * chicken_tacos, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(fish_tacos >= 20, "min_fish_tacos")
m.addConstr(chicken_tacos >= 40, "min_chicken_tacos")
m.addConstr(fish_tacos <= 50, "max_fish_tacos")
m.addConstr(chicken_tacos <= 60, "max_chicken_tacos")
m.addConstr(fish_tacos + chicken_tacos <= 80, "total_tacos")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Fish tacos: {fish_tacos.x}")
    print(f"Chicken tacos: {chicken_tacos.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

