
from gurobipy import *

# Create a new model
m = Model("TacoStand")

# Define variables
x1 = m.addVar(lb=20, ub=50, vtype=GRB.INTEGER, name="fish_tacos")
x2 = m.addVar(lb=40, ub=60, vtype=GRB.INTEGER, name="chicken_tacos")

# Set the objective function
m.setObjective(6*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 80, "total_tacos_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of fish tacos: {x1.x}")
    print(f"Number of chicken tacos: {x2.x}")
    print(f"Total profit: {6*x1.x + 4*x2.x}")
else:
    print("No optimal solution found")
