
import gurobipy as gp

# Create a new model
m = gp.Model("Taco Stand Optimization")

# Define variables
x1 = m.addVar(name="fish_tacos", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="chicken_tacos", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)

# Objective function: Maximize 6*x1 + 4*x2
m.setObjective(6*x1 + 4*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 >= 20, name="min_fish_tacos")
m.addConstr(x2 >= 40, name="min_chicken_tacos")
m.addConstr(x1 <= 50, name="max_fish_tacos")
m.addConstr(x2 <= 60, name="max_chicken_tacos")
m.addConstr(x1 + x2 <= 80, name="total_tacos")

# Update model
m.update()

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
  print(f"Optimal solution: Fish tacos = {x1.varValue}, Chicken tacos = {x2.varValue}")
else:
  print("No optimal solution found")
