
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ramen_stock")

# Create variables
large = m.addVar(vtype=GRB.INTEGER, name="large")  # Number of large packages
small = m.addVar(vtype=GRB.INTEGER, name="small")  # Number of small packages


# Set objective function: Maximize profit
m.setObjective(3 * large + 0.5 * small, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * large + 1 * small <= 2000, "budget")  # Budget constraint
m.addConstr(3 * large + 1 * small <= 400, "shelf_space")  # Shelf space constraint
m.addConstr(small >= 0.7 * (large + small), "small_package_ratio")  # Small package ratio constraint
m.addConstr(large >= 0, "non_negativity_large")  # Non-negativity constraint
m.addConstr(small >= 0, "non_negativity_small")  # Non-negativity constraint


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
    # Compute and print IIS (Irreducible Inconsistent Subsystem)
    m.computeIIS()
    m.write("model.ilp")
    print("IIS written to file 'model.ilp'")
else:
    # Print optimal solution
    print(f"Optimal number of large packages: {large.x}")
    print(f"Optimal number of small packages: {small.x}")
    print(f"Optimal profit: {m.objVal}")

