
from gurobipy import *

# Create a new model
m = Model("Ramen_Inventory")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="large_packages")
x2 = m.addVar(vtype=GRB.INTEGER, name="small_packages")

# Set the objective function
m.setObjective(3*x1 + 0.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + x2 <= 2000, "budget")
m.addConstr(3*x1 + x2 <= 400, "shelf_space")
m.addConstr(7*x1 <= 3*x2, "small_packages_percentage")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Large Packages: {x1.x}")
    print(f"Small Packages: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
