
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="large_packages")
    x2 = model.addVar(lb=0, name="small_packages")

    # Objective function
    model.setObjective(3*x1 + 0.5*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x1 + x2 <= 2000, name="budget_constraint")
    model.addConstr(3*x1 + x2 <= 400, name="shelf_space_constraint")
    model.addConstr(0.3*x1 - 0.7*x2 <= 0, name="small_packages_percentage")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Large packages: {x1.varValue}")
        print(f"Small packages: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
