
import gurobipy as gp

# Create a new model
m = gp.Model("repairman_problem")

# Create variables
fridges = m.addVar(vtype=gp.GRB.INTEGER, name="fridges")
ovens = m.addVar(vtype=gp.GRB.INTEGER, name="ovens")

# Set objective function
m.setObjective(100 * fridges + 125 * ovens, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * fridges + 30 * ovens <= 1000, "inspection_time")
m.addConstr(30 * fridges + 15 * ovens <= 800, "fixing_time")
m.addConstr(fridges >= 0, "fridges_nonnegative")
m.addConstr(ovens >= 0, "ovens_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of fridges to repair: {fridges.x}")
    print(f"Number of ovens to repair: {ovens.x}")
    print(f"Maximum earnings: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

