
from gurobipy import *

# Create a model
m = Model("Repairman_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="fridges")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="ovens")

# Set the objective function
m.setObjective(100*x1 + 125*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 30*x2 <= 1000, "inspection_time")
m.addConstr(30*x1 + 15*x2 <= 800, "fixing_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of fridges: {x1.x}")
    print(f"Number of ovens: {x2.x}")
    print(f"Total earnings: ${100*x1.x + 125*x2.x:.2f}")
else:
    print("No optimal solution found.")
