
import gurobipy as gp

# Create a new model
model = gp.Model("Repairman_Optimization")

# Define variables
x1 = model.addVar(name="fridges", lb=0, vtype=gp.GRB.INTEGER)  # Number of fridges
x2 = model.addVar(name="ovens", lb=0, vtype=gp.GRB.INTEGER)    # Number of ovens

# Objective function: Maximize earnings
model.setObjective(100*x1 + 125*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 30*x2 <= 1000, name="inspection_time")  # Inspection time constraint
model.addConstr(30*x1 + 15*x2 <= 800, name="fixing_time")      # Fixing time constraint

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Max earnings: ${100*x1.x + 125*x2.x:.2f}")
else:
    print("No optimal solution found.")
