
import gurobipy as gp

# Create a new model
m = gp.Model("diet_problem")

# Create variables
pizza = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pizza")
donuts = m.addVar(vtype=gp.GRB.CONTINUOUS, name="donuts")


# Set objective function
m.setObjective(4 * pizza + 2 * donuts, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(300 * pizza + 200 * donuts >= 3000, "calories")
m.addConstr(10 * pizza + 7 * donuts >= 200, "fat")
m.addConstr(pizza >=0)
m.addConstr(donuts >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Number of pizzas: {pizza.x:.2f}")
    print(f"Number of donuts: {donuts.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

