
from gurobipy import *

# Create a new model
m = Model("Actor_Diet")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="pizzas")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="donuts")

# Set objective function
m.setObjective(4*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(300*x1 + 200*x2 >= 3000, "calorie_constraint")
m.addConstr(10*x1 + 7*x2 >= 200, "fat_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of pizzas: {x1.x}")
    print(f"Number of donuts: {x2.x}")
    print(f"Total cost: ${4*x1.x + 2*x2.x:.2f}")
else:
    print("No optimal solution found")
