
import gurobipy as gp

def solve_actor_diet_problem():
    # Create a new model
    model = gp.Model("ActorDiet")

    # Define variables
    x1 = model.addVar(name="pizzas", lb=0, vtype=gp.GRB.CONTINUOUS)
    x2 = model.addVar(name="donuts", lb=0, vtype=gp.GRB.CONTINUOUS)

    # Objective function: minimize cost
    model.setObjective(4*x1 + 2*x2, gp.GRB.MINIMIZE)

    # Constraints
    model.addConstr(300*x1 + 200*x2 >= 3000, name="calories")
    model.addConstr(10*x1 + 7*x2 >= 200, name="fat")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found")

solve_actor_diet_problem()
