
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
paper_investment = m.addVar(name="paper_investment")
glass_investment = m.addVar(name="glass_investment")

# Set objective function
m.setObjective(0.02 * paper_investment + 0.05 * glass_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(paper_investment + glass_investment <= 300000, "total_investment")
m.addConstr(paper_investment >= 0.3 * 300000, "min_paper_investment")
m.addConstr(glass_investment <= 0.5 * 300000, "max_glass_investment")
m.addConstr(paper_investment >= 0, "non_negative_paper")
m.addConstr(glass_investment >= 0, "non_negative_glass")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in paper industry: {paper_investment.x}")
    print(f"Optimal investment in glass industry: {glass_investment.x}")
    print(f"Maximum return: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

