
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the variables
x1 = m.addVar(lb=0, name="Paper_Industry_Investment")
x2 = m.addVar(lb=0, name="Glass_Industry_Investment")

# Set the objective function
m.setObjective(0.02*x1 + 0.05*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 300000, "Total_Investment")
m.addConstr(x1 >= 90000, "Minimum_Paper_Industry_Investment")
m.addConstr(x2 <= 150000, "Maximum_Glass_Industry_Investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in Paper Industry: {x1.x}")
    print(f"Amount invested in Glass Industry: {x2.x}")
else:
    print("No optimal solution found")
