
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="paper_investment", lb=0)
    x2 = model.addVar(name="glass_investment", lb=0)

    # Objective function: Maximize 0.02x1 + 0.05x2
    model.setObjective(0.02 * x1 + 0.05 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 == 300000)  # Total investment
    model.addConstr(x1 >= 0.3 * 300000)  # Minimum in paper industry
    model.addConstr(x2 <= 0.5 * 300000)  # Maximum in glass industry

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in paper industry: $", x1.varValue)
        print("Optimal investment in glass industry: $", x2.varValue)
        print("Maximum return: ", 0.02 * x1.varValue + 0.05 * x2.varValue)
    else:
        print("No optimal solution found")

solve_investment_problem()
