
import gurobipy as gp

# Create a new model
m = gp.Model("coffee_shop")

# Create variables
large_coffees = m.addVar(vtype=gp.GRB.CONTINUOUS, name="large_coffees")
small_coffees = m.addVar(vtype=gp.GRB.CONTINUOUS, name="small_coffees")


# Set objective function
m.setObjective(5 * large_coffees + 3 * small_coffees, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * large_coffees + 8 * small_coffees <= 1000, "coffee_beans_constraint")
m.addConstr(20 * large_coffees + 15 * small_coffees <= 1500, "milk_constraint")
m.addConstr(large_coffees >= 0, "non_negativity_large")
m.addConstr(small_coffees >= 0, "non_negativity_small")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of large coffees: {large_coffees.x}")
    print(f"Number of small coffees: {small_coffees.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

