
from gurobipy import *

# Create a model
m = Model("Coffee Shop Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="large_coffees")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="small_coffees")

# Set the objective function
m.setObjective(5*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 8*x2 <= 1000, "coffee_beans")
m.addConstr(20*x1 + 15*x2 <= 1500, "milk")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of large coffees: {x1.x}")
    print(f"Number of small coffees: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
