
import gurobi

def solve_coffee_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="large_coffees", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="small_coffees", lb=0, ub=gurobi.GRB.INFINITY)

    # Set the objective function
    model.setObjective(5 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * x1 + 8 * x2 <= 1000, name="coffee_beans_constraint")
    model.addConstr(20 * x1 + 15 * x2 <= 1500, name="milk_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: large coffees = {x1.varValue}, small coffees = {x2.varValue}")
        print(f"Maximum profit: ${5 * x1.varValue + 3 * x2.varValue:.2f}")
    else:
        print("No optimal solution found")

solve_coffee_shop_problem()
