
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Ticket_Optimization")

# Create variables
vehicle_tickets = m.addVar(vtype=GRB.INTEGER, name="vehicle_tickets")
passenger_tickets = m.addVar(vtype=GRB.INTEGER, name="passenger_tickets")

# Set objective function
m.setObjective(130 * vehicle_tickets + 60 * passenger_tickets, GRB.MAXIMIZE)

# Add constraints
m.addConstr(vehicle_tickets + passenger_tickets <= 200, "Capacity_Limit")
m.addConstr(vehicle_tickets >= 20, "Min_Vehicle_Tickets")
m.addConstr(passenger_tickets >= 4 * vehicle_tickets, "Passenger_Vehicle_Ratio")

# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Number of vehicle tickets: {vehicle_tickets.x}")
    print(f"Number of passenger tickets: {passenger_tickets.x}")
    print(f"Maximum profit: ${m.objVal}")

