
from gurobipy import *

# Create a new model
m = Model("Boat_Company_Optimization")

# Add variables
x1 = m.addVar(name='vehicle_tickets', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='passenger_tickets', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(130*x1 + 60*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 200, name='total_tickets')
m.addConstr(x1 >= 20, name='min_vehicle_tickets')
m.addConstr(x2 >= 4*x1, name='passenger_to_vehicle_ratio')

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal}")
    print(f"Vehicle tickets sold: {x1.x}")
    print(f"Passenger tickets sold: {x2.x}")
else:
    print("No optimal solution found")
