
import gurobi

def solve_boat_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="vehicle_tickets", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="passenger_tickets", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 130*x1 + 60*x2
    model.setObjective(130*x1 + 60*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 200, name="total_tickets")
    model.addConstr(x1 >= 20, name="min_vehicle_tickets")
    model.addConstr(x2 >= 4*x1, name="passenger_to_vehicle_ratio")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Vehicle tickets = {x1.varValue}, Passenger tickets = {x2.varValue}")
    else:
        print("No optimal solution found.")

solve_boat_company_problem()
