
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("gift_wrapping")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="small_gifts") # number of small gifts
x2 = m.addVar(vtype=GRB.INTEGER, name="large_gifts") # number of large gifts


# Set objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 720, "worker_time")
m.addConstr(2*x1 + 3*x2 <= 150, "wrapping_paper")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Profit: ${m.objVal}")
    print(f"Number of small gifts to wrap: {x1.x}")
    print(f"Number of large gifts to wrap: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

