
import gurobi

def solve_gift_wrapping_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0, ub=gurobi.GRB.INFINITY, obj=3)  # small gifts
    x2 = model.addVar(name='x2', lb=0, ub=gurobi.GRB.INFINITY, obj=5)  # large gifts

    # Add constraints
    model.addConstr(x1 * 10 + x2 * 15 <= 720, name='worker_time')
    model.addConstr(x1 * 2 + x2 * 3 <= 150, name='wrapping_paper')

    # Set the objective function
    model.setObjective(x1 * 3 + x2 * 5, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${3*x1.varValue + 5*x2.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_gift_wrapping_problem()
