
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("crop_optimization")

# Create variables
oats = m.addVar(name="oats")  # Acres of oats
flaxseed = m.addVar(name="flaxseed")  # Acres of flaxseed

# Set objective function
m.setObjective(500 * oats + 400 * flaxseed, GRB.MAXIMIZE)

# Add constraints
m.addConstr(oats + flaxseed <= 50, "total_acres")
m.addConstr(oats >= 5, "min_oats")
m.addConstr(flaxseed >= 8, "min_flaxseed")
m.addConstr(oats <= 2 * flaxseed, "oats_flaxseed_ratio")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Oats: {oats.x}")
    print(f"Acres of Flaxseed: {flaxseed.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

