
from gurobipy import *

# Create a new model
m = Model("Farm_Profit")

# Define variables
x1 = m.addVar(name="oats", lb=0)
x2 = m.addVar(name="flaxseed", lb=0)

# Set the objective function
m.setObjective(500*x1 + 400*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 50, name="total_land")
m.addConstr(x1 >= 5, name="min_oats")
m.addConstr(x2 >= 8, name="min_flaxseed")
m.addConstr(x1 <= 2*x2, name="oats_vs_flaxseed")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of oats: {x1.x}")
    print(f"Acres of flaxseed: {x2.x}")
    print(f"Maximum profit: ${500*x1.x + 400*x2.x:.2f}")
else:
    print("No optimal solution found")
