
import gurobipy as gp

# Create a new model
m = gp.Model("farmer")

# Define the variables
x1 = m.addVar(name="oats", lb=0)  # acres of oats
x2 = m.addVar(name="flaxseed", lb=0)  # acres of flaxseed

# Objective function: maximize profit
m.setObjective(500*x1 + 400*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 50, name="total_land")
m.addConstr(x1 >= 5, name="min_oats")
m.addConstr(x2 >= 8, name="min_flaxseed")
m.addConstr(x1 <= 2*x2, name="oats_vs_flaxseed")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of oats: {x1.varValue}")
    print(f"Optimal acres of flaxseed: {x2.varValue}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("The model is infeasible.")
