
from gurobipy import Model, GRB

# Create a new model
m = Model("Cindy's Juice Problem")

# Create variables
orange_juice = m.addVar(vtype=GRB.CONTINUOUS, name="orange_juice")  # x1
apple_juice = m.addVar(vtype=GRB.CONTINUOUS, name="apple_juice")  # x2


# Set objective function: Minimize Glycine
m.setObjective(7 * orange_juice + 1 * apple_juice, GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * orange_juice + 5 * apple_juice >= 30, "Lysine_constraint")
m.addConstr(3 * orange_juice + 5 * apple_juice >= 40, "Alanine_constraint")
m.addConstr(5 * orange_juice + 2 * apple_juice <= 50, "Methionine_constraint")
m.addConstr(orange_juice >= 0, "orange_juice_nonnegative")
m.addConstr(apple_juice >= 0, "apple_juice_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: ")
    print(f"Glasses of orange juice: {orange_juice.x}")
    print(f"Glasses of apple juice: {apple_juice.x}")
    print(f"Minimum Glycine: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

