
from gurobipy import *

# Create a new model
m = Model("Cindy_Juice")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="orange_juice")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="apple_juice")

# Set the objective function
m.setObjective(7*x1 + x2, GRB.MINIMIZE)

# Add the constraints
m.addConstr(2*x1 + 5*x2 >= 30, "lysine_constraint")
m.addConstr(3*x1 + 5*x2 >= 40, "alanine_constraint")
m.addConstr(5*x1 + 2*x2 <= 50, "methionine_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Orange juice: {x1.x} glasses")
    print(f"Apple juice: {x2.x} glasses")
else:
    print("No optimal solution found")
