
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="orange_juice", lb=0)
x2 = model.addVar(name="apple_juice", lb=0)

# Define the objective function
model.setObjective(7 * x1 + x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * x1 + 5 * x2 >= 30, name="Lysine_constraint")
model.addConstr(3 * x1 + 5 * x2 >= 40, name="Alanine_constraint")
model.addConstr(5 * x1 + 2 * x2 <= 50, name="Methionine_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Glasses of orange juice: {x1.varValue}")
    print(f"Glasses of apple juice: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
