
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Potato Transportation")

# Create variables
trucks = m.addVar(vtype=GRB.INTEGER, name="trucks")
vans = m.addVar(vtype=GRB.INTEGER, name="vans")

# Set objective function
m.setObjective(150 * trucks + 80 * vans, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * trucks + 12 * vans <= 250, "Budget")
m.addConstr(trucks < vans, "Traffic Law")
m.addConstr(trucks >= 0, "Non-negative trucks")  # Explicit non-negativity constraints
m.addConstr(vans >= 0, "Non-negative vans")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of trucks: {trucks.x}")
    print(f"Number of vans: {vans.x}")
    print(f"Number of potatoes transported: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

