
from gurobipy import *

# Create a model
m = Model("Potato_Transport")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="trucks")
x2 = m.addVar(vtype=GRB.INTEGER, name="vans")

# Objective function: Maximize the total potatoes transported
m.setObjective(150*x1 + 80*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*x1 + 12*x2 <= 250)  # Cost constraint
m.addConstr(x1 < x2)  # Traffic law constraint
m.addConstr(x1 >= 0)  # Non-negativity constraint for trucks
m.addConstr(x2 >= 0)  # Non-negativity constraint for vans

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {m.objVal} potatoes transported")
    print(f"Trucks used: {x1.x}")
    print(f"Vans used: {x2.x}")
else:
    print("No optimal solution found")

