
import gurobi

def solve_potato_transportation():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='trucks', lb=0, vtype=gurobi.GRB.INTEGER)  # Number of trucks
    x2 = model.addVar(name='vans', lb=0, vtype=gurobi.GRB.INTEGER)   # Number of vans

    # Objective function: Maximize 150*x1 + 80*x2
    model.setObjective(150*x1 + 80*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20*x1 + 12*x2 <= 250, name='cost_constraint')  # Cost constraint
    model.addConstr(x1 <= x2 - 1, name='truck_van_constraint')     # Truck-Van constraint, converted to <= for MIP

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of trucks: {x1.varValue}")
        print(f"Optimal number of vans: {x2.varValue}")
        print(f"Maximum potatoes transported: {150*x1.varValue + 80*x2.varValue}")
    else:
        print("The problem is infeasible.")

solve_potato_transportation()
