
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Orange Transportation")

# Create variables
train_trips = m.addVar(vtype=GRB.INTEGER, name="train_trips")
car_trips = m.addVar(vtype=GRB.INTEGER, name="car_trips")

# Set objective function
m.setObjective(500 * train_trips + 200 * car_trips, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50 * train_trips + 30 * car_trips <= 500, "budget_constraint")
m.addConstr(train_trips <= car_trips, "scheduling_constraint")
m.addConstr(train_trips >=0, "non_negativity_train")
m.addConstr(car_trips >=0, "non_negativity_car")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of train trips: {train_trips.x}")
    print(f"Number of car trips: {car_trips.x}")
    print(f"Total oranges transported: {500 * train_trips.x + 200 * car_trips.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

