
from gurobipy import *

# Create a new model
m = Model("Orange Farm Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="train_trips")
x2 = m.addVar(vtype=GRB.INTEGER, name="car_trips")

# Set the objective function
m.setObjective(500*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 30*x2 <= 500, "budget_constraint")
m.addConstr(x1 <= x2, "scheduling_constraint")
m.addConstr(x1 >= 0, "non_neg_train_trips")
m.addConstr(x2 >= 0, "non_neg_car_trips")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of train trips: {x1.x}")
    print(f"Number of car trips: {x2.x}")
    print(f"Total oranges sent: {500*x1.x + 200*x2.x}")
else:
    print("No optimal solution found")
