
import gurobi

def solve_orange_farm_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='train_trips', obj=0, vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name='car_trips', obj=0, vtype=gurobi.GRB.INTEGER, lb=0)

    # Set objective function coefficients
    x1.obj = -500  # Negative because Gurobi minimizes by default
    x2.obj = -200  # Negative because Gurobi minimizes by default

    # Add constraints
    model.addConstr(50 * x1 + 30 * x2 <= 500, name='budget_constraint')
    model.addConstr(x1 <= x2, name='train_car_constraint')

    # Set model to maximize
    model.setObjective(model.getObjective(), gurobi.GRB.MAXIMIZE)

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {model.getVarByName('train_trips').x} train trips, {model.getVarByName('car_trips').x} car trips")
        print(f"Maximum oranges sent: {500*model.getVarByName('train_trips').x + 200*model.getVarByName('car_trips').x}")
    else:
        print("No optimal solution found")

solve_orange_farm_problem()
